<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('complaints_demands', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('demand_id');
            $table->integer('complaint_type');
            $table->text('message')->nullable();
            $table->string('ip_address');
            $table->string('device');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('complaints_demands');
    }
};
