<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('message_details', function (Blueprint $table) {
            $table->id();
            $table->integer('message_id');
            $table->longText('message')->nullable();
            $table->integer('offer')->nullable();
            $table->string('image')->nullable();
            $table->integer('type')->comment('İlk Mesaj Gönderen: 0 - Alıcı: 1');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('message_details');
    }
};
