<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use App\Models\Ads\Ads;
use App\Models\Demands\Demands;
use App\Models\UserPremium;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'phone_visibility',
        'phone',
        'phone_verified',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    public static function getUsersByRole(string $role = 'admin')
    {
        return User::whereHas('roles', function($q) use ($role) { $q->where('name', $role); });
    }

    public function ads(): HasMany
    {
        return $this->hasMany(Ads::class, 'user_id', 'id');
    }

    public function demands(): HasMany
    {
        return $this->hasMany(Demands::class, 'user_id', 'id');
    }

    public function favorites(): HasMany
    {
        return $this->hasMany(Favorites::class, 'user_id', 'id');
    }

    public function premiums(): HasMany
    {
        return $this->hasMany(UserPremium::class, 'user_id', 'id');
    }
}
