<?php

namespace App\Models;

use App\Models\Ads\Ads;
use App\Models\Demands\Demands;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class IncomingDemands extends Model
{
    use HasFactory;
    protected $table = 'incoming_demands';

    public function demand_user(): HasOne
    {
        return $this->hasOne(User::class, 'id', 'demand_user_id');
    }

    public function user(): HasOne
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function demand(): HasOne
    {
        return $this->hasOne(Demands::class, 'id', 'demand_id');
    }

    public function ad(): HasOne
    {
        return $this->hasOne(Ads::class, 'id', 'ad_id');
    }
}
