<?php

namespace App\Models\Demands;

use App\Models\Variant\VariantOptions;
use App\Models\Variant\Variants;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class DemandsVariants extends Model
{
    use HasFactory;

    protected $table = 'demands_variants';

    protected $fillable = ['demand_id', 'variant_id', 'variant_option_id', 'variant_option'];


    public function variant(): HasOne
    {
        return $this->hasOne(Variants::class, 'id', 'variant_id');
    }

    public function variantOption(): HasOne
    {
        return $this->hasOne(VariantOptions::class, 'id', 'variant_options_id');
    }
}
