<?php

namespace App\Models\Demands;

use App\Models\Ads\AdsPrices;
use App\Models\Ads\AdsVariants;
use App\Models\Categories;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Turkey\Cities\Models\City;
use Turkey\Cities\Models\County;

class Demands extends Model
{
    use HasFactory;

    protected $table = 'demands';

    public function category(): HasOne
    {
        return $this->hasOne(Categories::class,'id', 'category_id');
    }

    public function user(): HasOne
    {
        return $this->hasOne(User::class,'id', 'user_id');
    }


    public function cityRela(): HasOne
    {
        return $this->hasOne(City::class, 'id', 'city');
    }

    public function districtRela(): HasOne
    {
        return $this->hasOne(County::class, 'id', 'district');
    }

    public function prices(): HasMany
    {
        return $this->hasMany(AdsPrices::class, 'ads_id', 'id')->orderBy('id', 'desc');;
    }

    public function variants(): HasMany
    {
        return $this->hasMany(DemandsVariants::class, 'demand_id', 'id');
    }
}
