<?php

namespace App\Models;

use App\Models\Demands\Demands;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ComplaintsDemands extends Model
{
    use HasFactory;

    protected $table = 'complaints_demands';

    protected $fillable = [
        'user_id',
        'demand_id',
        'complaint_type',
        'message',
        'ip_address',
        'device'
    ];

    public function demand(): HasOne
    {
        return $this->hasOne(Demands::class, 'id', 'demand_id');
    }

    public function user(): HasOne
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
}
