<?php

namespace App\Models;

use App\Models\Ads\Ads;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Complaints extends Model
{
    use HasFactory;

    protected $table = 'complaints';

    protected $fillable = [
        'user_id',
        'ad_id',
        'complaint_type',
        'message',
        'ip_address',
        'device'
    ];

    public function ad(): HasOne
    {
        return $this->hasOne(Ads::class, 'id', 'ad_id');
    }

    public function user(): HasOne
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
}
