<?php

namespace App\Models;

use App\Models\Variant\Variants;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class CategoryVariants extends Model
{
    use HasFactory;

    protected $table = 'category_variants';

    public function category(): HasOne
    {
        return $this->hasOne(Categories::class, 'id', 'category_id');
    }

    public function variant(): HasOne
    {
        return $this->hasOne(Variants::class, 'id', 'variant_id');
    }
}
