<?php

namespace App\Models;

use App\Models\Ads\Ads;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AuctionBids extends Model
{
    use HasFactory;

    protected $table = 'auction_bids';

    protected $fillable = [
        'ad_id',
        'user_id',
        'price_offer',
    ];

    public function user(): HasOne
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function ad(): HasOne
    {
        return $this->hasOne(Ads::class, 'id', 'ad_id');
    }
}
