<?php

namespace App\Models\Ads;

use App\Models\Variant\VariantOptions;
use App\Models\Variant\Variants;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AdsVariants extends Model
{
    use HasFactory;
    protected $table = 'ads_variants';

    public function variant(): HasOne
    {
        return $this->hasOne(Variants::class, 'id', 'variant_id');
    }

    public function variantOption(): HasOne
    {
        return $this->hasOne(VariantOptions::class, 'id', 'variant_options_id');
    }
}
