<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Spatie\Permission\Models\Role;

class UserListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request)
    {
        $role = Role::where('name', $this->getRoleNames()->first())->first();

        return [
            'id' => $this->id,
            'status' => $this->status,
            'name' => $this->name,
            'email' => $this->email,
            'role' => $role->title,
            'credit' => $this->credit,
            'credit_type' => $this->credit_type,
            'created_at' => $this->created_at,
        ];
    }
}
