<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Spatie\Permission\Models\Role;

class UserAuthResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request)
    {
        $role = Role::where('name', $this->getRoleNames()->first())->first();
        return [
            'name' => $this->name,
            'email' => $this->email,
            'role' => $this->getRoleNames()->first(),
            'roleName' => $role->title,
            'ability' => $this->additional
        ];
    }

    public $additional;

    public function additional(array $data)
    {
        return parent::additional($data);
    }

    /**
     * @return array
     */
    public function getAdditional(): array
    {
        return $this->additional;
    }

    /**
     * @param mixed $additional
     */
    public function setAdditional(array $additional)
    {
        $this->additional = $additional;
    }
}
