<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserAuthCheckResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // Premium kontrolü - aktif premium üyelik var mı?
        $hasPremium = $this->premiums()
            ->where('end_date', '>', now())
            ->where('status', 'active')
            ->exists();
            
        return [
            'id' => $this->id,
            'uniq' => $this->uniq_id,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'phone_verified' => $this->phone_verified,
            'verified' => $this->verified,
            'visibility' => $this->phone_visibility,
            'is_premium' => $hasPremium,
            'message' => 'success'
        ];
    }
}
