<?php

namespace App\Http\Resources\Settings;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;

class HomeSetting extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'button_text' => $this->button_text,
            'button_link' => $this->button_link,
            'image' => url(Storage::url($this->image)),
            'status' => $this->status,
        ];
    }
}
