<?php

namespace App\Http\Resources\Message;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MessagesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'url' => '/messages/'.$this->uniq,
            'messageUserType' => auth('sanctum')->id() === $this->sender->id ? 0 : 1,
            'sender' => [
                'name' => $this->sender->name,
                'image' => 'https://ui-avatars.com/api/?name='.$this->sender->name.'&rounded=true&size=128',
                'profil' => '#'
            ],
            'recipient' => [
                'name' => $this->recipient->name,
                'image' => 'https://ui-avatars.com/api/?name='.$this->recipient->name.'&rounded=true&size=128',
                'profil' => '#'
            ],
            'status' => auth('sanctum')->id() === $this->sender->id ? $this->sender_status : $this->recipient_status
        ];
    }
}
