<?php

namespace App\Http\Resources\Message;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;

class MessageDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'adTitle' => $this->ads_id ? $this->ad->title : $this->demand->title,
            'adImage' => $this->ads_id ? url(Storage::url($this->ad->gallery[0]->thumb)) : null,
            'adPrice' => $this->ads_id ? $this->ad->price : null,
            'min_price' => $this->demand_id ? $this->demand->min_price : null,
            'max_price' => $this->demand_id ? $this->demand->max_price : null,
            'adSlug' => $this->ads_id ? '/ad/'.$this->ad->slug : '/d/'.$this->demand->slug,
            'messageUserType' => auth('sanctum')->id() === $this->sender->id ? 0 : 1,
            'sender' => [
                'name' => $this->sender->name,
                'image' => 'https://ui-avatars.com/api/?name='.$this->sender->name.'&rounded=true&size=128',
                'profil' => '#'
            ],
            'recipient' => [
                'name' => $this->recipient->name,
                'image' => 'https://ui-avatars.com/api/?name='.$this->recipient->name.'&rounded=true&size=128',
                'profil' => '#',
                'phone' => $this->recipient->phone_visibility && $this->recipient->phone_verified === 1 ? $this->recipient->phone : null,
            ],
            'messages' => MessageDetailListResource::collection($this->messageDetail),
            'type' => $this->ads_id ? 1 : 0
        ];
    }
}
