<?php

namespace App\Http\Resources\IncomingDemands;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'demand_user' => [
                'id' => $this->demand_user->id,
                'name' => $this->demand_user->name,
                'uniq_id' => $this->user->uniq_id
            ],
            'user' => [
                'id' => $this->user->id,
                'name' => $this->user->name,
                'uniq_id' => $this->user->uniq_id
            ],
            'demand' => [
                'title' => $this->demand->title,
                'slug' => $this->demand->slug
            ],
            'ad' => [
                'title' => $this->ad->title,
                'slug' => $this->ad->slug
            ],
            'offer' => $this->offer ?? null,
            'message' => $this->message ?? null,
        ];
    }
}
