<?php

namespace App\Http\Resources\Doping;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Carbon;

class PurchasedDopingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'title' => $this->dopingPackage->title,
            'ads' => $this->ads->title,
            'adsUrl' => url('ad/edit/'.$this->ads->id),
            'price' => $this->price,
            'start_date' => Carbon::parse($this->start_date)->locale('tr_TR')->isoFormat('LLL'),
            'end_date' => Carbon::parse($this->end_date)->locale('tr_TR')->isoFormat('LLL'),
            'status' => $this->status,
        ];
    }
}
