<?php

namespace App\Http\Resources\Demands;

use App\Models\Categories;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $categories = Categories::ancestorsAndSelf($this->category->id);
        $catagory = [];
        foreach ($categories as $item){
            $catagory[] = $item->name;
        }
        $catagory = implode(' -> ', $catagory);
        return [
            'id' => $this->id,
            'category' => $catagory,
            'user' => $this->user->name,
            'title' => $this->title,
            'city' => $this->cityRela->name,
            'district' => $this->districtRela->name,
            'description' => $this->description,
            'status' => $this->status
        ];
    }
}
