<?php

namespace App\Http\Resources\ComplaintDemands;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'demand' => [
                'id' => $this->demand->id,
                'name' => $this->demand->title,
            ],
            'user' => [
                'id' => $this->user->id,
                'name' => $this->user->name
            ],
            'type' => $this->complaint_type,
            'message' => $this->message,
            'ip_address' => $this->ip_address,
            'device' => $this->device,
        ];
    }
}
