<?php

namespace App\Http\Resources\Blog;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;

class EditResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'title' => $this->title,
            'description' => $this->description,
            'image' => url(Storage::url($this->image)),
            'status' => $this->status,
            'site_title' => $this->site_title,
            'site_desc' => $this->site_desc,
            'site_keyw' => $this->site_keyw,
            'slug' => $this->slug,
        ];
    }
}
