<?php

namespace App\Http\Resources\Api;

use App\Models\Categories;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;

class MyAdsListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $categories = Categories::ancestorsAndSelf($this->category->id);
        $catagory = [];
        foreach ($categories as $item){
            $catagory[] = $item->name;
        }
        $catagory = implode(' -> ', $catagory);
        return [
            'id' => $this->id,
            'category' => $catagory,
            'slug' => $this->slug,
            'user' => $this->user->name,
            'price' => $this->price,
            'title' => $this->title,
            'city' => $this->cityRela->name,
            'district' => $this->districtRela->name,
            'description' => $this->description,
            'status' => $this->status,
            'thumb' => $this->gallery->isNotEmpty()
                ? url(Storage::url($this->gallery[0]->thumb))
                : asset('img/no-image.png'),
            'type' => $this->type
        ];
    }
}
