<?php

namespace App\Http\Resources\Ads;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryVariantListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->variant->id,
            'name' => $this->variant->name,
            'type' => $this->variant->type,
            'options' => $this->variant->variantOptions ? CategoryVariantOptionsListResource::collection($this->variant->variantOptions) : null
        ];
    }
}
