<?php

namespace App\Http\Controllers;

use App\Http\Resources\Pages\EditResource;
use App\Http\Resources\Pages\ListResource;
use App\Models\Pages;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class PagesController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;

        $pages = Pages::orderBy('id', 'DESC')->paginate($perPage);

        return response()->json([
            'pagination' => $pages,
            'collection' => ListResource::collection($pages)
        ]);
    }

    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'description' => 'required',
            'status' => 'required',
            'type' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }


        $pages = new Pages();
        $pages->title = $request->title;
        $pages->description = $request->description;
        $pages->status = $request->status;
        $pages->type = $request->type;
        $pages->slug = Str::slug($request->title);
        $pages->sss_status = $request->sss_status ?? 0;
        $pages->save();

        return response()->json([
            'status' => 'Success',
            'message' => 'Sayfa Başarılı Şekilde Eklendi'
        ]);
    }

    public function update(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'description' => 'required',
            'status' => 'required',
            'type' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }


        $pages = Pages::find($request->id);
        $pages->title = $request->title;
        $pages->description = $request->description;
        $pages->status = $request->status;
        $pages->type = $request->type;
        $pages->slug = Str::slug($request->title);
        $pages->sss_status = $request->sss_status ?? 0;
        $pages->save();

        return response()->json([
            'status' => 'Success',
            'message' => 'Sayfa Başarılı Şekilde Güncellendi'
        ]);
    }

    public function edit(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $pages = Pages::find($request->id);
        return response()->json(new EditResource($pages));
    }

    public function destroy(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $pages =  Pages::find($request->id);
        $pages->delete();

        return response()->json([
            'status' => 'Success',
            'message' => 'Sayfa Başarılı Şekilde Silindi'
        ]);
    }
}
