<?php

namespace App\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;

class IntegrationsController extends Controller
{
    public function index(): JsonResponse
    {
        return response()->json([
            'title' => env('NETGSM_TITLE'),
            'username' => env('NETGSM_USER'),
            'password' => env('NETGSM_PASSWORD'),
            'appkey' => env('NETGSM_APPKEY'),
            'status' => env('NETGSM_STATUS'),
        ]);
    }

    public function update(Request $request): JsonResponse
    {
        config(['env.NETGSM_TITLE' => $request->title]);
        config(['env.NETGSM_USER' => $request->username]);
        config(['env.NETGSM_PASSWORD' => $request->password]);
        config(['env.NETGSM_APPKEY' => $request->appkey]);
        config(['env.NETGSM_STATUS' => $request->status]);
        Artisan::call('config:cache');

        return response()->json([
            'status' => 'success',
            'message' => 'NETGSM Ayarları Kaydedildi'
        ]);
    }
}
