<?php

namespace App\Http\Controllers;

use App\Http\Resources\Doping\PurchasedAdsResource;
use App\Http\Resources\Doping\PurchasedDopingListResource;
use App\Http\Resources\Doping\PurchasedDopingResource;
use App\Http\Resources\DopingPackages\EditResource;
use App\Http\Resources\DopingPackages\ListResource;
use App\Models\Ads\Ads;
use App\Models\Ads\AdsDoping;
use App\Models\DopingPackages;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Validator;

class DopingPackagesController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;

        $variant = DopingPackages::orderBy('id', 'DESC')->paginate($perPage);

        return response()->json([
            'pagination' => $variant,
            'collection' => ListResource::collection($variant)
        ]);
    }

    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'day' => 'required',
            'price' => 'required',
            'title' => 'required',
            'status' => 'required',
            'type' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()->first()
            ], 400);
        }

        $dopingPackage = new DopingPackages();
        $dopingPackage->day = $request->day;
        $dopingPackage->price = $request->price;
        $dopingPackage->title = $request->title;
        $dopingPackage->type = $request->type;
        $dopingPackage->status = $request->status;
        $dopingPackage->save();

        return response()->json([
            'status' => 'Success',
            'message' => 'Doping Paketi Başarılı Şekilde Eklendi'
        ]);
    }

    public function edit(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $category = DopingPackages::find($request->id);
        return response()->json(new EditResource($category));
    }

    public function update(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'day' => 'required',
            'price' => 'required',
            'title' => 'required',
            'status' => 'required',
            'type' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $dopingPackage = DopingPackages::find($request->id);
        $dopingPackage->day = $request->day;
        $dopingPackage->price = $request->price;
        $dopingPackage->title = $request->title;
        $dopingPackage->status = $request->status;
        $dopingPackage->type = $request->type;
        $dopingPackage->save();

        return response()->json([
            'status' => 'Success',
            'message' => 'Doping Paketi Başarılı Şekilde Güncellendi'
        ]);
    }

    public function destroy(Request $request): JsonResponse
    {

        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $variant =  DopingPackages::find($request->id);
        $variant->delete();

        return response()->json([
            'status' => 'Success',
            'message' => 'Doping Paketi Başarılı Şekilde Silindi'
        ]);
    }
    public function purchased(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;

        $dopings = AdsDoping::with('dopingPackage')->orderBy('id', 'DESC')->paginate($perPage);

        return response()->json([
            'pagination' => $dopings,
            'collection' => PurchasedDopingResource::collection($dopings)
        ]);
    }
    public function destroyDoping(Request $request): JsonResponse
    {

        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $variant =  AdsDoping::find($request->id);
        $variant->delete();

        return response()->json([
            'status' => 'Success',
            'message' => 'Doping Paketi Başarılı Şekilde Silindi'
        ]);
    }

    public function adsList(): JsonResponse
    {
        $ads = Ads::where('status', 1)->get();
        return response()->json(PurchasedAdsResource::collection($ads));
    }
    public function dopingList(): JsonResponse
    {
        $doping = DopingPackages::where('status', 1)->get();
        return response()->json(PurchasedDopingListResource::collection($doping));
    }

    public function purcDoping(Request $request): JsonResponse
    {
        $dopingPackage = DopingPackages::find($request->doping);
        $startDate = Carbon::now()->toDateTimeString();
        $endDate = Carbon::now()->addDays($dopingPackage->day)->toDateTimeString();

        $adsDoping = new AdsDoping();
        $adsDoping->ads_id = $request->ad;
        $adsDoping->doping_id = $dopingPackage->id;
        $adsDoping->start_date = $startDate;
        $adsDoping->end_date = $endDate;
        $adsDoping->price = $dopingPackage->price;
        $adsDoping->status = 1;
        $adsDoping->uniq = uniqid();
        $adsDoping->save();

        return response()->json([
            'status' => 'success',
            'message' => 'Doping Başarılı Şekilde Eklendi'
        ]);
    }
}
