<?php

namespace App\Http\Controllers;

use App\Http\Resources\Demands\EditResource;
use App\Http\Resources\Demands\ListResource;
use App\Http\Resources\Demands\MyEditResource;
use App\Models\Demands\Demands;
use App\Models\Demands\DemandsVariants;
use App\Models\Variant\VariantOptions;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class DemandsController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;

        $demands = Demands::orderBy('id', 'DESC')->paginate($perPage);

        return response()->json([
            'pagination' => $demands,
            'collection' => ListResource::collection($demands)
        ]);
    }

    public function pendings(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;

        $demands = Demands::orderBy('id', 'DESC')->where('status', 0)->paginate($perPage);

        return response()->json([
            'pagination' => $demands,
            'collection' => ListResource::collection($demands)
        ]);
    }

    public function edit(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $demands = Demands::find($request->id);
        return response()->json(new EditResource($demands));
    }

    public function update(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'title' => 'required',
            'min_price' => 'required',
            'max_price' => 'required',
            'category' => 'required',
            'user' => 'required',
            'city' => 'required',
            'district' => 'required',
            'description' => 'required',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $demand = Demands::find($request->id);
        if (!$demand) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Talep Bulunamadı'
            ], 400);
        }
        $demand->title = $request->title;
        $demand->min_price = $request->min_price;
        $demand->max_price = $request->max_price;
        $demand->category_id = $request->category;
        $demand->user_id = $request->user;
        $demand->city = $request->city;
        $demand->district = $request->district;
        $demand->description = $request->description;
        $demand->status = $request->status;
        $demand->save();

        /** Talep Varyantları */
        $varyantOne = array_filter(json_decode($request->variantOne));
        $varyantTwo = array_filter(json_decode($request->variantTwo));
        $varyantThree = array_filter(json_decode($request->variantThree));

        $demand->variants()->delete();

        if($varyantOne){
            foreach ($varyantOne as $one){
                $variantGetOne = VariantOptions::find($one);
                $adsVariantOne = new DemandsVariants();
                $adsVariantOne->demand_id = $demand->id;
                $adsVariantOne->variant_id = $variantGetOne->variant_id;
                $adsVariantOne->variant_option_id = $variantGetOne->id;
                $adsVariantOne->variant_option = $variantGetOne->name;
                $adsVariantOne->save();
            }
        }

        if($varyantTwo){
            foreach ($varyantTwo as $two){
                $variantGetTwo = VariantOptions::find($two);
                $adsVariantTwo = new DemandsVariants();
                $adsVariantTwo->demand_id = $demand->id;
                $adsVariantTwo->variant_id = $variantGetTwo->variant_id;
                $adsVariantTwo->variant_option_id = $variantGetTwo->id;
                $adsVariantTwo->variant_option = $variantGetTwo->name;
                $adsVariantTwo->save();
            }
        }

        if($varyantThree){
            foreach ($varyantThree as $key => $three){
                $adsVariantThree = new DemandsVariants();
                $adsVariantThree->demand_id = $demand->id;
                $adsVariantThree->variant_id = $key;
                $adsVariantThree->variant_option_id = null;
                $adsVariantThree->variant_option = $three;
                $adsVariantThree->save();
            }
        }

        return response()->json([
            'status' => 'Success',
            'message' => 'Talep Başarılı Şekilde Güncellendi'
        ]);


    }

    public function destroy(Request $request){
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $demand = Demands::find($request->id);
        if (!$demand) {
            return response()->json([
                'status' => 'Error',
                'message' => 'İlan Bulunamadı'
            ], 400);
        }

        $demand->variants()->delete();
        $demand->delete();

        return response()->json([
            'status' => 'Success',
            'message' => 'İlan Başarılı Şekilde Silindi'
        ]);

    }

    public function approveOrReject(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $demand = Demands::find($request->id);
        if (!$demand) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Talep Bulunamadı'
            ], 400);
        }
        $demand->status = $request->status;
        $demand->cancel_message = $request->cancelMessage ? $request->cancelMessage : null;
        $demand->save();

        return response()->json([
            'status' => 'Success',
            'message' => $request->status === "1" ? 'Talep başarılı şekilde yayınlandı.' : 'Talep yayın için reddedildi'
        ]);


    }

    /** API Talep İşlemleri */
    public function myDemandStore(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'category' => 'required',
            'city' => 'required',
            'district' => 'required',
            'description' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $demand = new Demands();
        $demand->title = $request->title;
        $demand->category_id = $request->category;
        $demand->min_price = $request->min_price;
        $demand->max_price = $request->max_price;
        $demand->user_id = auth('sanctum')->id();
        $demand->city = $request->city;
        $demand->district = $request->district;
        $demand->description = $request->description;
        $demand->slug = Str::slug($request->title.'-'.rand(111111, 9999999));
        $demand->status = 0;
        $demand->save();

        $demand->demand_no = 'TLP' . str_pad($demand->id, 10, '0', STR_PAD_LEFT);
        $demand->save();


        /** Talep Varyantları */
        $varyantOne = array_filter(json_decode($request->variantOne));
        $varyantTwo = array_filter(json_decode($request->variantTwo));
        $varyantThree = array_filter(json_decode($request->variantThree));

        if($varyantOne){
            foreach ($varyantOne as $one){
                $variantGetOne = VariantOptions::find($one);
                $demandVariantOne = new DemandsVariants();
                $demandVariantOne->demand_id = $demand->id;
                $demandVariantOne->variant_id = $variantGetOne->variant_id;
                $demandVariantOne->variant_option_id = $variantGetOne->id;
                $demandVariantOne->variant_option = $variantGetOne->name;
                $demandVariantOne->save();
            }
        }

        if($varyantTwo){
            foreach ($varyantTwo as $two){
                $variantGetTwo = VariantOptions::find($two);
                $demandVariantTwo = new DemandsVariants();
                $demandVariantTwo->demand_id = $demand->id;
                $demandVariantTwo->variant_id = $variantGetTwo->variant_id;
                $demandVariantTwo->variant_option_id = $variantGetTwo->id;
                $demandVariantTwo->variant_option = $variantGetTwo->name;
                $demandVariantTwo->save();
            }
        }

        if($varyantThree){
            foreach ($varyantThree as $key => $three){
                $demandVariantThree = new DemandsVariants();
                $demandVariantThree->demand_id = $demand->id;
                $demandVariantThree->variant_id = $key;
                $demandVariantThree->variant_option_id = null;
                $demandVariantThree->variant_option = $three;
                $demandVariantThree->save();
            }
        }

        return response()->json([
            'status' => 'Success',
            'message' => 'Talebiniz Başarılı Şekilde Paylaşıldı'
        ]);


    }

    public function myDemandUpdate(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'slug' => 'required',
            'title' => 'required',
            'category' => 'required',
            'city' => 'required',
            'district' => 'required',
            'description' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $demand = Demands::where('slug', $request->slug)
            ->where('user_id', auth('sanctum')->id())
            ->first();

        if (!$demand) {
            return response()->json([
                'status' => 'Error',
                'message' => 'Talep bulunamadı.'
            ], 404);
        }

        // Ana talep bilgilerini güncelle
        $demand->title = $request->title;
        $demand->category_id = $request->category;
        $demand->min_price = $request->min_price;
        $demand->max_price = $request->max_price;
        $demand->city = $request->city;
        $demand->district = $request->district;
        $demand->description = $request->description;
        $demand->status = 0;
        $demand->save();

        // Eski varyantları sil
        DemandsVariants::where('demand_id', $demand->id)->delete();

        /** Talep Varyantları */
        $varyantOne = array_filter(json_decode($request->variantOne));
        $varyantTwo = array_filter(json_decode($request->variantTwo));
        $varyantThree = array_filter(json_decode($request->variantThree));

        if ($varyantOne) {
            foreach ($varyantOne as $one) {
                $variantGetOne = VariantOptions::find($one);
                if ($variantGetOne) {
                    $demandVariantOne = new DemandsVariants();
                    $demandVariantOne->demand_id = $demand->id;
                    $demandVariantOne->variant_id = $variantGetOne->variant_id;
                    $demandVariantOne->variant_option_id = $variantGetOne->id;
                    $demandVariantOne->variant_option = $variantGetOne->name;
                    $demandVariantOne->save();
                }
            }
        }

        if ($varyantTwo) {
            foreach ($varyantTwo as $two) {
                $variantGetTwo = VariantOptions::find($two);
                if ($variantGetTwo) {
                    $demandVariantTwo = new DemandsVariants();
                    $demandVariantTwo->demand_id = $demand->id;
                    $demandVariantTwo->variant_id = $variantGetTwo->variant_id;
                    $demandVariantTwo->variant_option_id = $variantGetTwo->id;
                    $demandVariantTwo->variant_option = $variantGetTwo->name;
                    $demandVariantTwo->save();
                }
            }
        }

        if ($varyantThree) {
            foreach ($varyantThree as $key => $three) {
                $demandVariantThree = new DemandsVariants();
                $demandVariantThree->demand_id = $demand->id;
                $demandVariantThree->variant_id = $key;
                $demandVariantThree->variant_option_id = null;
                $demandVariantThree->variant_option = $three;
                $demandVariantThree->save();
            }
        }

        return response()->json([
            'status' => 'Success',
            'message' => 'Talebiniz başarıyla güncellendi.'
        ]);
    }


    public function myDemandEdit(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'slug' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $ad = Demands::where('slug', $request->slug)->where('user_id', auth('sanctum')->id())->first();
        if (!$ad) {
            return response()->json([
                'status' => 'error',
                'message' => 'Talep Bulunamadı'
            ], 400);
        }
        return response()->json(new MyEditResource($ad));
    }
}
