<?php

namespace App\Http\Controllers;

use App\Models\Ads\Ads;
use App\Models\Ads\AdsDoping;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index(): JsonResponse
    {
        $adsCount = Ads::where('status', 1)->count();
        $adsCountTotal = Ads::count();
        $adsDoping = AdsDoping::where('status', 1)->count();
        $user = User::count();

        return response()->json([
            'ads' => $adsCount,
            'adsTotal' => $adsCountTotal,
            'adsDoping' => $adsDoping,
            'user' => $user
        ]);
    }
}
