<?php

namespace App\Http\Controllers\Cron;

use App\Http\Controllers\Controller;
use App\Models\ExchangeRates;
use Illuminate\Http\Request;

class ExchangeRatesController extends Controller
{
    public function store()
    {

        $JSONString = array(
            "success" => false,
            "tarih" => "",
            "bulten_no" => "",
            "results" => array()
        );

        $date = (!empty($date) ? $date : 'today');
        if ($date == 'today') {
            $url = 'https://www.tcmb.gov.tr/kurlar/today.xml';
        } else {

            $yil = substr($date, 4, 4);
            $ay = substr($date, 2, 2);
            $url = 'https://www.tcmb.gov.tr/kurlar/' . $yil . $ay . '/' . $date . '.xml';

        }

        try {
            $sxe = true;
            $xml = simplexml_load_file($url);
        } catch (\Exception $e) {
            $sxe = false;
        }

        if (false === $sxe) {
            $JSONString['results'][] = array(
                'message' => 'Tarih Hatalı'
            );
        } else {
            $count = 1;
            $Tarih_Date = (string)$xml->attributes()->Tarih;
            $Bulten_No = (string)$xml->attributes()->Bulten_No;
            $JSONString['tarih'] = $Tarih_Date;
            $JSONString['bulten_no'] = $Bulten_No;
            foreach ($xml->children() as $children) {
                $CurrencyCode = (string)$children->attributes()->CurrencyCode;
                $CurrencyName = (string)$children->CurrencyName;
                $ForexBuying = (string)$children->ForexBuying;
                $exchangeRates = ExchangeRates::where('currency_code', '=', $CurrencyCode)->first();

                if ($exchangeRates){
                    $exchangeRates->price = $ForexBuying;
                    $exchangeRates->save();
                }else{
                    $newExchangeRates = new ExchangeRates();
                    $newExchangeRates->currency_code = $CurrencyCode;
                    $newExchangeRates->currency_name = $CurrencyName;
                    $newExchangeRates->price = $ForexBuying;
                    $newExchangeRates->save();
                }
            }
            return response()->json([
                'status' => 'Success',
                'message' => __('Cron Currency Added'),
            ], 200);
        }
    }
}
