<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Resources\Contact\ListResource;
use App\Http\Resources\Contact\ViewResource;
use App\Models\Contacts;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class ContactsController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;
        $contact = Contacts::orderBy('id', 'desc')->paginate($perPage);

        return response()->json([
            'pagination' => $contact,
            'collection' => ListResource::collection($contact)
        ]);
    }

    public function view(Request $request): JsonResponse
    {
        $contact = Contacts::find($request->id);
        if (!$contact) {
            return response()->json([
                'status' => false,
                'message' => 'Mesaj Bulunamadı'
            ]);
        }

        return response()->json(new ViewResource($contact));
    }

    public function destroy(Request $request): JsonResponse
    {
        $contact = Contacts::find($request->id);
        if (!$contact) {
            return response()->json([
                'status' => false,
                'message' => 'Mesaj Bulunamadı'
            ]);
        }
        $contact->delete();

        return response()->json([
            'status' => true,
            'message' => 'Mesaj Başarıyla Silindi'
        ]);
    }
}
