<?php

namespace App\Http\Controllers;
use App\Http\Resources\Blog\EditResource;
use App\Http\Resources\Blog\ListResource;
use App\Models\Blogs;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class BlogController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $perPage = $request->perPage ?? 10;

        $blog = Blogs::orderBy('id', 'DESC')->paginate($perPage);

        return response()->json([
            'pagination' => $blog,
            'collection' => ListResource::collection($blog)
        ]);
    }

    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'description' => 'required',
            'status' => 'required',
            'image' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }


        $blog = new Blogs();
        $blog->title = $request->title;
        $blog->description = $request->description;
        $blog->status = $request->status;
        $blog->user_id = auth()->user()->id;
        $blog->slug = Str::slug($request->title);

        $name = time() . rand(1111111111, 999999999999999) . '.' . $request->file('image')->extension();
        $file_path = $request->file('image')->storeAs('uploads/blogs', $name, 'public');
        $blog->image = $file_path;

        $blog->site_title = $request->siteTitle;
        $blog->site_desc = $request->siteDesc;
        $blog->site_keyw = $request->siteKeyw;
        $blog->save();

        return response()->json([
            'status' => 'Success',
            'message' => 'Blog Başarılı Şekilde Eklendi'
        ]);
    }

    public function update(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'description' => 'required',
            'status' => 'required',
            'image' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }


        $blog = Blogs::find($request->id);
        $blog->title = $request->title;
        $blog->description = $request->description;
        $blog->status = $request->status;
        $blog->user_id = auth()->user()->id;
        $blog->slug = Str::slug($request->title);

        if ($request->file('image')){
            if (Storage::disk('public')->exists($blog->image)) {
                Storage::disk('public')->delete($blog->image);
            }
            $name = time() . rand(1111111111, 999999999999999) . '.' . $request->file('image')->extension();
            $file_path = $request->file('image')->storeAs('uploads/blogs', $name, 'public');
            $blog->image = $file_path;
        }

        $blog->site_title = $request->siteTitle;
        $blog->site_desc = $request->siteDesc;
        $blog->site_keyw = $request->siteKeyw;
        $blog->save();

        return response()->json([
            'status' => 'Success',
            'message' => 'Blog Başarılı Şekilde Güncellendi'
        ]);
    }

    public function edit(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $blog = Blogs::find($request->id);
        return response()->json(new EditResource($blog));
    }
    public function destroy(Request $request): JsonResponse
    {

        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'Error',
                'message' => $validator->errors()
            ], 400);
        }

        $blog =  Blogs::find($request->id);
        if (Storage::disk('public')->exists($blog->image)) {
            Storage::disk('public')->delete($blog->image);
        }
        $blog->delete();

        return response()->json([
            'status' => 'Success',
            'message' => 'Blog Başarılı Şekilde Silindi'
        ]);
    }
}
